/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawning;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupDemon;
import com.lycanitesmobs.core.spawning.CustomSpawner;
import com.lycanitesmobs.core.spawning.SpawnTypeDeath;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnTypeUndeath
extends SpawnTypeDeath {
    public SpawnTypeUndeath(String typeName) {
        super(typeName);
        CustomSpawner.instance.deathSpawnTypes.add(this);
    }

    @Override
    public boolean isValidKill(EntityLivingBase entity, EntityLivingBase killer) {
        if (entity == null || killer == null) {
            return false;
        }
        return entity.func_70668_bt() == EnumCreatureAttribute.UNDEAD && !(entity instanceof IGroupDemon) && entity.getClass() != ObjectManager.getMob("geist");
    }

    @Override
    public boolean canSpawn(long tick, World world, BlockPos pos, int rank) {
        double roll = world.field_73012_v.nextDouble();
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (worldExt != null && "blackplague".equalsIgnoreCase(worldExt.getWorldEventType())) {
            roll /= 4.0;
        }
        return !(roll >= this.chance);
    }
}

